﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Es3
{
    class Program
    {
        static string stringaDaNumero(BigInteger m)
        {
            StringBuilder sb = new StringBuilder();
            BigInteger resto;

            while (m > 0)
            {
                char ch;
                resto = m % 100;    // Si considerano solo le ultime due cifre del numero
                if (resto == 99)
                    ch = ' ';
                else
                    // Dato che A -> 10, B -> 11, ..., essendo i codici ASCII delle lettere
                    // ascii(A) = 65, ascii(B) = 66, ..., per ottenere il codice ASCII del carattere 
                    // si incrementa il resto di (65 - 10) = 55
                    ch = (char)(resto.IntValue() + 55);

                sb.Insert(0, ch);

                m /= 100;      // Eliminazione delle ultime due cifre 
            }

            return sb.ToString();
        }

        static void Main(string[] args)
        {
            // N = 59 11142 11035 79513
            BigInteger p = new BigInteger(27910973);
            BigInteger q = new BigInteger(2117855981);
            BigInteger e = new BigInteger(123);
            BigInteger phi, d, N;
            
            N = p*q;
            phi = (p-1) * (q-1);
            d = e.modInverse(phi);

            Console.WriteLine("PU: (e={0}, N={1}) ", e, N);
            Console.WriteLine("PR: (d={0}, N={1}) ", d, N);

            BigInteger[] cVett = new BigInteger[4] {
                39257365738083976,
                8665717059956870,
                145693993449451,
                14575413675404137
            };

            BigInteger[] mVett = new BigInteger[4];

            for (int i = 0; i < cVett.Length; i++)
            {
                mVett[i] = cVett[i].modPow(d, N);
                Console.WriteLine("mVett[{0}] = {1}", i, mVett[i]);

            }

            foreach (var m in mVett)
                Console.Write(stringaDaNumero(m));

            Console.WriteLine();
            

        }
    }
}
